/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.base.connectors;

import data.base.Database;
import data.base.NoBaseException;
import data.structures.corpus.CorpusItem;

import proc.text.Codecs;

import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Vector;

public class CorpusDatabase {

    private Database theDB;

    public CorpusDatabase(Database db) {
        theDB = db;
    }

    public Vector<CorpusItem> loadCorpus() throws NoBaseException {
        Vector<CorpusItem> result = new Vector<CorpusItem>();
        try {
            ResultSet items = theDB.executeSelection(
                    "SELECT idRSSItem, name, description, idThema FROM ipri_corpus_etude;");
            while (items.next()) {
                int idRSSItem = items.getInt(1);
                String titleRSSItem = Codecs.desEscapeHTML(items.getString(2));
                String descRSSItem = Codecs.desEscapeHTML(items.getString(3));
                int conceptId = items.getInt(4);
                CorpusItem ci = new CorpusItem(idRSSItem, titleRSSItem, descRSSItem, conceptId);
                result.add(ci);
            }
        } catch (SQLException se) {
            se.printStackTrace();
        }
        return result;
    }

    public void saveCorpus(Vector<CorpusItem> items) throws NoBaseException {
        theDB.executeInsertOrUpdate("DELETE FROM ipri_corpus_etude");

        for (int i = 0; i < items.size(); i++) {
            String query = "INSERT INTO ipri_corpus_etude VALUES (NULL, "+
                    ""+items.elementAt(i).getIdItem() + ", '" +
                    Codecs.escapeHTML(items.elementAt(i).getRSSItemTitle()) + "', '" +
                    Codecs.escapeHTML(items.elementAt(i).getRSSItemDesc()) + "', "+
                    items.elementAt(i).getThemaId()+")  ";
            theDB.executeInsertOrUpdate(query);
        }
    }

    public Vector<CorpusItem> createClusteringCorpus(int taille) throws NoBaseException {
        Vector<CorpusItem> result = new Vector<CorpusItem>();
        try {
            ResultSet items = theDB.executeSelection(
                    "SELECT id, titre, description, datePubli " +
                    "FROM rss_articles " +
                    "ORDER BY datePubli DESC " +
                    "LIMIT "+taille+";");
            while (items.next()) {
                int id = items.getInt(1);
                String titre = Codecs.desEscapeHTML(items.getString(2));
                String desc = Codecs.desEscapeHTML(items.getString(3));
                CorpusItem ci = new CorpusItem(id, titre, desc, 0);
                result.add(ci);
            }
        } catch (SQLException se) {
            se.printStackTrace();
        }
        return result;
    }
}
